/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.base.logon.Logon;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.tasklet.PanelTask;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponseListener;
import com.ibm.hwmca.fw.tasklet.xport.AbnormalTaskletTerminationWithDetailsException;
import com.ibm.hwmca.fw.tasklet.xport.TaskletControlException;
import com.ibm.hwmca.fw.util.HThreadGroup;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.UserTaskManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;

public class TaskLauncher
implements Runnable,
TaskErrorIds,
PanelTaskletResponseListener {
    private static final String TRACE_MASKT = "XFRMTLHT";
    private static final String TRACE_MASKF = "XFRMTLHF";
    private static final String TRACE_MASKD = "XFRMTLHD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "TaskLauncher");
    private static HashMap tasks = new HashMap();
    private static Object tasksMapLock = new Object();
    private static long taskId = 0L;
    private static Timer timer = new Timer(true);
    private static boolean areServletClassesAvailable;
    private static boolean areJSPClassesAvailable;
    private PresentationTask task;
    private boolean gotResponse = false;
    private ClientUserContext context = null;

    private TaskLauncher(PresentationTaskParms parms, String className, HMCSession hmcSession, ClientUserContext context) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Trace.trace(TRACE_MASKT, "-> TaskLauncher.ctor");
        Class[] aClass = new Class[]{parms.getClass()};
        Class<?> ptClass = Class.forName(className);
        Constructor<?> ctor = ptClass.getConstructor(aClass);
        Object[] args = new Object[]{parms};
        this.task = (PresentationTask)ctor.newInstance(args);
        if (hmcSession != null) {
            this.task.setHMCSession(hmcSession);
        }
        this.context = context;
        Trace.trace(TRACE_MASKT, "ClientUserContext is: [" + context + "]");
        if (context != null) {
            Trace.trace(TRACE_MASKT, "   user name is: [" + context.getUserName() + "]");
        }
        Trace.trace(TRACE_MASKT, "<- TaskLauncher.ctor");
    }

    public static PresentationTask startTask(PresentationTaskParms parms, String className) throws HException, IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "<> TaskLauncher.startTask() #1");
        return TaskLauncher.startTask(parms, className, null, false);
    }

    public static PresentationTask startTask(PresentationTaskParms parms, String className, HMCSession hmcSession, boolean delay) throws HException, IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "<> TaskLauncher.startTask() #2");
        return TaskLauncher.startTask(parms, className, hmcSession, delay, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PresentationTask startTask(PresentationTaskParms parms, String className, HMCSession hmcSession, boolean delay, ClientUserContext context) throws HException, IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> TaskLauncher.startTask() #3");
        if (parms == null) {
            throw new IllegalArgumentException("null parms specified");
        }
        if (hmcSession == null && CommonSystem.getCommonSystem().isUsingHTML()) {
            throw new IllegalArgumentException("An HMCSession must be specified when using the HTML user interface.");
        }
        parms.setTechnologyType(UserTaskManager.getTechnologyType());
        try {
            Trace.trace(TRACE_MASKT, "ClientUserContext is: [" + context + "]");
            if (context != null) {
                Trace.trace(TRACE_MASKT, "   user name is: [" + context.getUserName() + "]");
            }
            TaskLauncher launcher = new TaskLauncher(parms, className, hmcSession, context);
            Thread thd = HThreadGroup.defaultThreadGroup().createThread(launcher, "Task_" + className);
            TaskLauncher taskLauncher = launcher;
            synchronized (taskLauncher) {
                thd.start();
                while (delay && !launcher.gotResponse) {
                    Trace.trace(TRACE_MASKF, "waiting for a response from the task");
                    try {
                        launcher.wait();
                    }
                    catch (InterruptedException exc) {}
                }
            }
            Trace.trace(TRACE_MASKT, "<- TaskLauncher.startTask() #3");
            return launcher.task;
        }
        catch (Throwable e) {
            Trace.trace(TRACE_MASKF, "Exception [" + e + "] caught trying to contruct TaskLauncher thread");
            HException ex = new HException(e);
            new FrameworkLog(classLogInfo, 48, ex).log();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PresentationTask[] getActiveTasks() {
        PresentationTask[] activeTasks;
        Object object = tasksMapLock;
        synchronized (object) {
            Collection theTasks = tasks.values();
            activeTasks = new PresentationTask[theTasks.size()];
            activeTasks = theTasks.toArray(activeTasks);
        }
        return activeTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PresentationTask getActiveTask(long id) {
        Trace.trace(TRACE_MASKT, "-> TaskLauncher.getActiveTask()");
        PresentationTask activeTask = null;
        Trace.trace(TRACE_MASKF, "looking for task: " + id + ".");
        Object object = tasksMapLock;
        synchronized (object) {
            Long lid = new Long(id);
            activeTask = (PresentationTask)tasks.get(lid);
        }
        Trace.trace(TRACE_MASKT, "<- TaskLauncher.getActiveTask()");
        return activeTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void taskEnded(PresentationTask task) {
        Trace.trace(TRACE_MASKT, "-> TaskLauncher.taskEnded()");
        PanelModelTaskPortal portal = task.getPanelModelTaskPortal();
        if (portal != null) {
            portal.terminateTask();
            portal.getHMCSession().taskEnded(portal);
        }
        Object object = tasksMapLock;
        synchronized (object) {
            tasks.remove(new Long(task.getTaskId()));
        }
        Trace.trace(TRACE_MASKT, "<- TaskLauncher.taskEnded()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Trace.trace(TRACE_MASKT, "-> TaskLauncher.run()");
        if (CommonSystem.getCommonSystem().isUsingHTML()) {
            this.task.getHMCSession().getUserContext().attachToThread(true);
        } else {
            Trace.trace(TRACE_MASKT, "ClientUserContext is: [" + this.context + "]");
            if (this.context != null) {
                Trace.trace(TRACE_MASKT, "   user name is: [" + this.context.getUserName() + "]");
            }
            if (this.context != null) {
                this.context.attachToThread(true);
            } else {
                Logon.getLogon().getClientUserContext().attachToThread(true);
            }
        }
        try {
            Object object = tasksMapLock;
            synchronized (object) {
                tasks.put(new Long(taskId), this.task);
                this.task.setTaskId(taskId);
                Trace.trace(TRACE_MASKF, "starting task: " + taskId + ".");
                ++taskId;
            }
            PanelModelTaskPortal portal = this.task.getPanelModelTaskPortal();
            if (portal != null) {
                portal.setTaskId(Long.toString(this.task.getTaskId()));
                portal.taskStarted();
                portal.getHMCSession().addTask(portal);
            }
            this.task.initTask(this);
        }
        catch (Exception e) {
            HException ex = new HException(e);
            new FrameworkLog(classLogInfo, 55, ex).log();
        }
        finally {
            TaskLauncher.taskEnded(this.task);
        }
        Trace.trace(TRACE_MASKT, "<- TaskLauncher.run()");
    }

    static void displayInternalErrorMessage(Throwable exception) {
        BaseMessageText msg = exception instanceof TaskletControlException ? new BaseMessageText("TSK0003") : new BaseMessageText("TSK0004");
        BaseMessageTitle title = new BaseMessageTitle("task.error.title");
        BaseMessageTitle details = null;
        details = new BaseMessageTitle("task.details.text");
        try {
            LocalizableText[] options = details != null ? new LocalizableText[]{CommonMsgInterface.OK_BUTTON, details} : new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
            LocalizableText answer = CommonMsgApp.showMessageBox(null, (LocalizableText)title, msg, msg.getMsgType(), options);
            if (details != null && answer == details) {
                String detailsMessage;
                if (exception instanceof AbnormalTaskletTerminationWithDetailsException) {
                    detailsMessage = ((AbnormalTaskletTerminationWithDetailsException)exception).getDetails();
                    if (exception.getMessage() != null) {
                        detailsMessage = exception.getMessage() + '\n' + detailsMessage;
                    }
                } else {
                    Throwable exc = exception;
                    StringWriter buffer = new StringWriter();
                    PrintWriter stack = new PrintWriter(buffer);
                    exc.printStackTrace(stack);
                    while (exc != null) {
                        if (areServletClassesAvailable && exc instanceof ServletException) {
                            exc = ((ServletException)exc).getRootCause();
                        } else {
                            if (!areJSPClassesAvailable || !(exc instanceof JspException)) break;
                            exc = ((JspException)exc).getRootCause();
                        }
                        if (exc == null) continue;
                        stack.println();
                        stack.println("Caused by:");
                        exc.printStackTrace(stack);
                    }
                    stack.flush();
                    detailsMessage = buffer.toString();
                }
                StringTokenizer tokens = new StringTokenizer(detailsMessage, "\n");
                StringBuffer buf = new StringBuffer();
                while (tokens.hasMoreTokens()) {
                    buf.append("<br>");
                    buf.append(tokens.nextToken());
                }
                BaseMessageText detailsmsg = new BaseMessageText("TSK0005", new String[]{buf.toString()});
                CommonMsgApp.showMessageBox(null, title, detailsmsg);
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
    }

    public static void dumpActiveTasks() {
        Trace.trace(TRACE_MASKF, "dumping the active tasks...");
        PresentationTask[] activeTasks = TaskLauncher.getActiveTasks();
        for (int i = 0; i < activeTasks.length; ++i) {
            Trace.trace(TRACE_MASKF, "  taskId is: " + activeTasks[i].getTaskId() + ", task objectId is [" + activeTasks[i].getParms().getTaskId() + "]");
        }
        Trace.trace(TRACE_MASKF, "end dumping the active tasks.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void response(PanelTask task, PanelTaskletResponse response) {
        Trace.trace(TRACE_MASKF, "-> TaskLauncher.response()");
        TaskLauncher taskLauncher = this;
        synchronized (taskLauncher) {
            if (!this.gotResponse) {
                this.gotResponse = true;
                this.notifyAll();
            }
        }
        Trace.trace(TRACE_MASKF, "<- TaskLauncher.response()");
    }

    ClientUserContext getUserContext() {
        return this.context;
    }

    static {
        try {
            Class.forName("javax.servlet.ServletException");
            areServletClassesAvailable = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            Class.forName("javax.servlet.jsp.JspException");
            areJSPClassesAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

